package h.com.serialapp.activity.fragment

import android.os.Bundle
import android.os.Handler
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import h.com.serialapp.R
import h.com.serialapp.adapter.LogAdapter
import h.com.serialportapi.comn.CommPacket
import h.com.serialportapi.comn.Packet
import h.com.serialportapi.comn.SerialReadThread
import h.com.serialportapi.comn.message.ICMessage
import h.com.serialportapi.comn.message.IMessage
import h.com.serialportapi.comn.message.LogManager
import kotlinx.android.synthetic.main.view_desfire.view.*
import java.util.*
import kotlin.collections.ArrayList

/**
 * Created by hxd on 2018/10/21.
 */
class DesFire : BasesFragment() {

    lateinit var views: View
    var logAdapter: LogAdapter = LogAdapter()
    override fun add(message: IMessage) {
        logAdapter.add(message)
        views.lv_log.setSelection(logAdapter.count - 1)
    }

    var handler = Handler(Handler.Callback { msg ->
        when (msg.what) {
            1 -> {
                views.et_tag_type.setText(icObject.tag_Type)
                views.et_sak.setText(icObject.sak)
                views.et_uid_number.setText(icObject.uiD_number)
            }
            2 -> {
                views.et_ats.setText(current.substring(4, current.length - 2))
            }
            3 -> {
                views.et_version.setText(current)
            }
        }
        false
    })

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        var view = inflater!!.inflate(R.layout.view_desfire, null)
        view.lv_log.adapter = logAdapter
        views = view
        views.btn_clear_log.setOnClickListener {
            LogManager.instance().clear()
            logAdapter.notifyDataSetChanged()
        }
        bindView()
        return view
    }

    lateinit var icObject: ICMessage
    lateinit var current: String
    fun bindView() {
        var idle = byteArrayOf(10, 26)
        views.bt_activeIDLE.setOnClickListener {
            CommPacket.PiccActivate(Packet(idle, 50, 2, 22).sendData, SerialReadThread.ActivityListener { message ->
                icObject = message
                handler.sendEmptyMessage(1)
            })
        }
        var all = byteArrayOf(10, 52)
        views.bt_activeALL.setOnClickListener {
            CommPacket.PiccActivate(Packet(all, 50, 2, 22).sendData, SerialReadThread.ActivityListener { message ->
                icObject = message
                handler.sendEmptyMessage(1)
            })
        }
        views.bt_rats.setOnClickListener {
            CommPacket.PiccRequestATS(null, SerialReadThread.ReaderListener { msg ->
                current = msg
                handler.sendEmptyMessage(2)
            })
        }
        views.bt_getVersion.setOnClickListener {
            CommPacket.DESGetDESVersion(null, SerialReadThread.ReaderListener { msg ->
                current = msg
                current = msg
                handler.sendEmptyMessage(3)
            })
        }
        views.bt_getKeyVersion.setOnClickListener {
            CommPacket.DESGetKeyVersion(null, SerialReadThread.ReaderListener { })
        }

        SerialReadThread.ReaderListener {  }
        views.bt_authenticate.setOnClickListener {
            CommPacket.DESAuthenticate(views.et_keyNum.text.toString(), views.et_key.text.toString(), SerialReadThread.ReaderListener { })
        }
        views.bt_getKeySetting.setOnClickListener {
            CommPacket.DESGetKeySetting(null, SerialReadThread.ReaderListener { })
        }
        views.bt_changeKeySetting.setOnClickListener {
            CommPacket.DESChangKeySetting(views.et_changeKeySetting.text.toString(), SerialReadThread.ReaderListener { })
        }
        views.bt_changeKey.setOnClickListener {
            CommPacket.DESChangKey(views.et_keyNums.text.toString(), views.et_keySetting.text.toString(), views.et_originalKey.text.toString(), views.et_newKey.text.toString(), SerialReadThread.ReaderListener { })
        }
      //  views.bt_piccLevel.setOnClickListener { CommPacket.DESGetApplication(SerialReadThread.DesFireListener { desFire -> Toast.makeText(activity, "aidno:" + desFire.aidno + "   aids:" + desFire.aids.toString(), Toast.LENGTH_LONG).show() }) }
        views.bt_applicationLevel.setOnClickListener { }
    }


}